<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Console\Command;

use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

/**
 * ApplicationUninstallCommand
 */
class ApplicationUninstallCommand extends AbstractApplicationCommand
{
    /**
     * {@inheritdoc}
     */
    protected function configure()
    {
        $this
            ->setName('application:uninstall')
            ->setDescription('Uninstalls an application')
            ->addArgument(
                'application',
                InputArgument::REQUIRED,
                'The name of the application being uninstalled'
            )
        ;
    }

    /**
     * {@inheritdoc}
     */
    public function execute(InputInterface $input, OutputInterface $output)
    {
        $this->facade->uninstall($input->getArgument('application'));
    }
}
