<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Application;

/**
 * OperationValidator.
 */
class OperationValidator
{
    /**
     * @var bool
     */
    protected $is_valid;

    /**
     * @var string
     */
    protected $motivation;

    /**
     * @param bool   $is_valid
     * @param string $motivation
     */
    public function __construct($is_valid = true, $motivation = '')
    {
        $this->is_valid = (bool) $is_valid;
        $this->motivation = (string) $motivation;
    }

    /**
     * @return bool
     */
    public function isValid()
    {
        return $this->is_valid;
    }

    /**
     * @return string
     */
    public function motivation()
    {
        return $this->motivation;
    }
}
