<?php

namespace Application\Core\Utilities;

use Application\Core\Model\Module;
use Application\Core\Model\ModuleOption;

class ModulesOptions
{
	protected $module_id;
	protected $options = array();

	public function __construct($module_id)
	{
		$this->module_id = intval($module_id);
		$this->options = $this->prepare($module_id);
	}

	protected function prepare($module_id)
	{
		$options = array();

		foreach ( ModuleOption::all_by_module_id($module_id) as $option )
		{
			$options[$option->name] = $option;
		}

		return array_merge(static::getDefault(), $options);
	}

	public static function getDefault()
	{
		return array();
	}

	public function get($name, $default = null)
	{
		if ( array_key_exists($name, $this->options) )
		{
			if ( $this->options[$name] instanceof ModuleOption )
			{
				return unserialize($this->options[$name]->value);
			}

			return $this->options[$name];
		}

		return $default;
	}

	public function set($name, $value)
	{
		if ( array_key_exists($name, $this->options) && $this->options[$name] instanceof ModuleOption )
		{
			$this->options[$name]->value = serialize($value);
		}
		else
		{
			$this->options[$name] = new ModuleOption(array(
				'module_id'	=> $this->module_id,
				'name'		=> $name,
				'value'		=> serialize($value),
			));
		}

		return $this;
	}

	public function has($name)
	{
		return array_key_exists($name, $this->options);
	}

	public function del($name)
	{
		unset($this->options[$name]);

		return $this;
	}

	public function __get($name)
	{
		return $this->get($name);
	}

	public function __set($name, $value)
	{
		$this->set($name, $value);
	}

	public function __isset($name)
	{
		return $this->has($name);
	}

	public function __unset($name)
	{
		$this->del($name);
	}

	public function save()
	{
		foreach ( $this->options as $name => $option )
		{
			if ( $option instanceof ModuleOption )
			{
				$option->save();
			}
		}
	}
}