<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Utilities;

use Application\Core\Model\Group;
use Application\Core\Model\Province;
use Application\Core\Model\Region;
use Application\Core\Model\Role;
use Pongho\Core\Kernel;
use Pongho\Template\Html as HtmlBase;

/**
 * Html
 */
class Html extends HtmlBase
{
    /**
     * Istanza della classe per il singleton.
     *
     * @var Html
     *
     * @deprecated
     */
    private static $instance;

    /**
     * Restituisce l’istanza della classe (Singleton).
     *
     * @return Html
     *
     * @deprecated
     */
    public static function instance()
    {
        if (is_null(self::$instance)) {
            self::$instance = new static;
        }

        return self::$instance;
    }

    /**
     * Genera una select con la lista delle regioni.
     *
     * @param int $region_id ID della regione da selezionare.
     * @return string
     */
    public function selectRegion($region_id = null)
    {
        $options = [];

        /** @var Region $region */
        foreach (Region::all(['order' => 'name']) as $region) {
            $options[$region->getId()] = $region->getName();
        }

        return $this->select($options, $region_id);
    }

    /**
     * Genera una select con la lista delle province.
     *
     * @param int    $province_id Indica la provincia da selezionare. Per il confronto viene usato il campo indicato in `$field`.
     * @param string $field       Il campo da usare come valore della select. Può essere `id`, `plate` o `name`.
     * @return string
     */
    public function selectProvince($province_id = null, $field = 'id')
    {
        $options = [];

        /** @var Province $province */
        foreach (Province::all(['order' => 'name']) as $province) {
            $options[$province->{$field}] = $province->name;
        }

        return $this->select($options, $province_id);
    }

    /**
     * Genera una select con la lista dei gruppi.
     *
     * @param int $group_id ID del gruppo da selezionare.
     * @return string
     */
    public function selectGroup($group_id = null)
    {
        $options = [];

        /** @var Group $group */
        foreach (Group::all(['order' => 'name']) as $group) {
            $options[$group->id] = $group->name;
        }

        return $this->select($options, $group_id);
    }

    /**
     * Genera una select con la lista dei ruoli.
     *
     * @param int   $role_id        ID del ruolo da selezionare.
     * @param array $excludes_roles Permette di escludere alcuni ruoli dalla select.
     * @return string
     */
    public function selectRole($role_id = null, array $excludes_roles = [])
    {
        $options = [];

        /** @var Role $role */
        foreach (Role::all(['order' => 'name']) as $role) {
            if (!in_array($role->id, $excludes_roles)) {
                $options[$role->id] = $role->name;
            }
        }

        return $this->select($options, $role_id);
    }

    /**
     * Genera una select con la lista delle lingue.
     *
     * @param int $language_id ID della lingua da selezionare.
     * @return string
     */
    public function selectLanguage($language_id = null)
    {
        $site = Kernel::instance()->getContainer()->get('site');

        $options = [];
        foreach ($site->getLanguages() as $language) {
            $options[$language->language_id] = $language->name;
        }

        return $this->select($options, $language_id);
    }
}
