<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Utilities;

use Doctrine\DBAL\Connection;

/**
 * ChangeDomainManager
 */
class ChangeDomainHandler
{
    /**
     * @var Connection
     */
    private $connection;

    /**
     * @var callable[]
     */
    private $queries = [];

    /**
     * @param Connection $connection
     */
    public function __construct(Connection $connection)
    {
        $this->connection = $connection;
    }

    /**
     * @param callable $query
     * @return $this
     */
    public function registerQuery(callable $query)
    {
        $this->queries[] = $query;

        return $this;
    }

    /**
     * @param string $oldDomain
     * @param string $newDomain
     */
    public function changeDomain($oldDomain, $newDomain)
    {
        $oldDomain = rtrim($oldDomain, '/');
        $newDomain = rtrim($newDomain, '/');

        foreach ($this->queries as $query) {
            call_user_func($query, $oldDomain, $newDomain);
        }
    }
}
