<?php
/**
 * Questo file è parte di Pongho.
 *
 * @author Daniele Termini
 * @package Application\Core
 */

namespace Application\Core\Updates;

use Doctrine\DBAL\Schema\Schema;
use Updates\SchemaUpdate;

/**
 * Class Update94
 */
class Update94 extends SchemaUpdate
{
    /**
     * {@inheritdoc}
     */
    protected function prepareSchema(Schema $schema)
    {
        $table = $schema->getTable('pongho_apps');

        if (!$table->hasColumn('load_order')) {
            $table->addColumn('load_order', 'integer', array('unsigned' => true, 'default' => 0));
        }
    }
}
