<?php
/**
 * Questo file è parte di Pongho.
 *
 * @author Daniele Termini
 * @package Application\Core
 */

namespace Application\Core\Updates;

use Application\Core\Model\Application;
use Application\Core\Model\ApplicationSite;
use Application\Core\Model\Site;
use Updates\BaseUpdate;

/**
 * Class Update87
 */
class Update87 extends BaseUpdate
{
    /**
     * {@inheritdoc}
     */
    public function commit()
    {
        $sql = 'INSERT INTO ' . ApplicationSite::tableName() . ' (app_id, site_id)
SELECT a.id AS app_id, s.id AS site_id
FROM ' . Application::tableName() . ' AS a
CROSS JOIN ' . Site::tableName() . ' AS s
WHERE is_installed = :installed AND is_enabled = :enabled';

        $this->connection->executeQuery($sql, array('enabled' => true, 'installed' => true));
    }
}
