<?php

/**
 * Questo file è parte di Pongho 2.0-dev.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   ???
 */

namespace Application\Core\Updates;

use Application\Core\Model\Account;
use Pongho\Utilities\DateTime;
use Updates\BaseUpdate;

class Update7 extends BaseUpdate
{
    /**
     * Esegue l'aggiornamento
     */
    public function commit()
    {
        foreach (Account::all(array('conditions' => array('id <> :id', 'id' => 1))) as $account) {

            $timestamp = '0';
            if ($account->created_at instanceof DateTime) {
                $timestamp = $account->created_at->format('U');
            }

            $account->url = (string) $timestamp . (string) random(8, '0123456789');

            $account->save(false);
        }
    }
}
