<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Updates;

use Application\Core\Installer\Helper\DatabaseSchemaHelper;
use Doctrine\DBAL\Schema\Schema;
use Updates\BaseUpdate;

/**
 * Update202
 *
 * Corregge la tabella degli indirizzi
 */
class Update202 extends BaseUpdate
{
    public function commit()
    {
        (new DatabaseSchemaHelper($this->connection))->update(function (Schema $schema) {

            $addresses = $schema->getTable('pongho_addresses');

            $addresses->changeColumn('country_id', ['notnull' => false]);
            $addresses->addForeignKeyConstraint($schema->getTable('pongho_provinces'), ['province_id'], ['id']);

        });
    }
}
