<?php

/**
 * Questo file è parte di Pongho 2.0-dev.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   ???
 */

namespace Application\Core\Updates;

use Doctrine\DBAL\Schema\Schema;
use Updates\SchemaUpdate;

class Update2 extends SchemaUpdate
{
    /**
     * manageSchema
     *
     * @param \Doctrine\DBAL\Schema\Schema $schema
     */
    protected function prepareSchema(Schema $schema)
    {
        if (!$schema->hasTable('pongho_apps')) {
            $table = $schema->createTable('pongho_apps');
            $table->addColumn('id', 'integer', array('unsigned' => true, 'autoincrement' => true));
            $table->addColumn('app_name', 'string', array('length' => 50));
            $table->addColumn('app_version', 'string', array('length' => 20));
            $table->addColumn('is_installed', 'boolean');
            $table->addColumn('is_enabled', 'boolean');
            $table->setPrimaryKey(array('id'));
        }
    }
}
