<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Updates;

use Updates\BaseUpdate;

/**
 * Update192
 *
 * Si assicura che tutte le email degli utenti siano in lowercase
 */
class Update192 extends BaseUpdate
{
    /**
     * {@inheritdoc}
     */
    public function commit()
    {
        $sth = $this->connection->prepare('SELECT id, email, username FROM pongho_users WHERE id <> 1');
        $sth->execute();

        foreach ($sth as $row) {
            $data = [
                'email' => strtolower($row['email']),
            ];

            if (preg_match('/^[a-z0-9&\'\.\-_\+]+@[a-z0-9\-]+\.([a-z0-9\-]+\.)*?[a-z]+$/is', $row['username'])) {
                $data['username'] = strtolower($row['username']);
            }

            $this->connection->update(
                'pongho_users',
                $data,
                [
                    'id' => $row['id']
                ],
                [
                    'id'       => \PDO::PARAM_INT,
                    'email'    => \PDO::PARAM_STR,
                    'username' => \PDO::PARAM_STR,
                ]
            );
        }
    }
}
