<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Updates;

use Doctrine\DBAL\Schema\Schema;
use Updates\SchemaUpdate;

/**
 * Class Update144
 */
class Update144 extends SchemaUpdate
{
    /**
     * prepareSchema
     *
     * @param \Doctrine\DBAL\Schema\Schema $schema
     */
    protected function prepareSchema(Schema $schema)
    {
        $table = $schema->getTable('pongho_regions');
        $table->changeColumn('country_id', array('unsigned' => true, 'notnull' => true));
        $table->addForeignKeyConstraint($schema->getTable('pongho_countries'), array('country_id'), array('id'));
    }
}
