<?php
/**
 * Questo file è parte di Pongho.
 *
 * @author Daniele Termini
 * @package ${PACKAGE}
 */

namespace Application\Core\Updates;

use Application\Core\Model\Translation;
use Updates\BaseUpdate;

class Update10 extends BaseUpdate
{
    public function commit()
    {
        Translation::addTranslation('url_change_explain', 'Permette di cambiare l\'url per accedere al profilo pubblico dell\'utente', 'user', null, 'it_IT');
        Translation::addTranslation('account_url_explain', '<p>Modifica l\'url per accedere al profilo pubblico dell\'utente.<br>
            L\'url può essere modificato una sola volta, perciò deve essere scelto con cura.<br>
            L\'url deve essere univoco, se un altro utente ha già utilizzato l\'url inserito, sarà necessario sceglierne un altro diverso.<br>
            Sono ammessi i caratteri minuscoli, i numeri e il trattino, l\'url non può iniziare con un numero.<br>
            La funzione di verifica controllerà la validità dell\'url e rimuoverà qualsiasi carattere non consentito.</p>', 'user', null, 'it_IT');
        Translation::addTranslation('preview_url', 'Verifica', 'user', null, 'it_IT');
        Translation::addTranslation('confirm_url', 'Conferma', 'user', null, 'it_IT');
        Translation::addTranslation('account_url_already_used', 'L\'url scelto è già stato utilizzato da un altro utente', 'user', null, 'it_IT');
        Translation::addTranslation('account_url_cannot_start_with_number', 'L\'url non può iniziare con un numero', 'user', null, 'it_IT');
        Translation::addTranslation('account_url_not_defined', 'L\'url non è stato indicato', 'user', null, 'it_IT');
        Translation::addTranslation('account_url_changed', 'Url modificato', 'user', null, 'it_IT');
        Translation::addTranslation('account_url_preview', 'L\'url è stato verificato, conferma per salvarlo', 'user', null, 'it_IT');
        Translation::addTranslation('account_url_title', 'Modifica url dell\'utente', 'user', null, 'it_IT');

        // Opzioni di configurazione
        Translation::addTranslation('account_url', 'Url profilo pubblico', 'admin', null, 'it_IT');
        Translation::addTranslation('account_url_enable_explain', 'Attiva l\'url per il profilo pubblico degli utenti', 'admin', null, 'it_IT');
    }
}
