<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Utilities
{
    if (!function_exists('Application\\Core\\Mailer\\absolute_url')) {
        /**
         * @param string $url
         * @return string
         */
        function absolute_url($url) {
            return $url;
        }
    }
}

namespace Application\Core\Tests\Utilities
{
    use Application\Core\Utilities\UserActivationLinkBuilder;

    class UserActivationLinkBuilderTest extends \PHPUnit_Framework_TestCase
    {
        public function testBuilder()
        {
            $builder = new UserActivationLinkBuilder();

            $account = $this->getAccountMock();
            $account->expects($this->any())->method('resetActivationKey')->willReturn($account);
            $account->expects($this->any())->method('save')->willReturn(true); // @todo AccountManager
            $account->expects($this->any())->method('getId')->willReturn(123);
            $account->expects($this->any())->method('getActivationKey')->willReturn('abc123def456');

            /**
             * @var \Application\Core\Entity\AccountInterface $account
             */

            $this->assertEquals('/user/activation/?u=123&amp;key=abc123def456', $builder->build($account));
        }

        protected function getAccountMock()
        {
            return $this->getMockBuilder('Application\Core\Model\Account')
                ->disableOriginalConstructor()
                ->getMock();
        }
    }
}
