<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Tests\Notification\Utilities;

use Application\Core\Entity\AccountInterface;
use Application\Core\Entity\LanguageInterface;
use Application\Core\Entity\NotificationTemplateInterface;
use Application\Core\Entity\SiteInterface;
use Application\Core\I18n\Translation\Translator;
use Application\Core\Model\Manager\NotificationTemplateManagerInterface;
use Application\Core\Notification\NotificationInterface;
use Application\Core\Notification\NotificationTemplateGeneratorInterface;
use Application\Core\Utilities\Mailer;
use Monolog\Logger;
use Pongho\Core\LocalizationInterface;

/**
 * Class MockProvider
 */
class MockProvider
{
    /**
     * @var \PHPUnit_Framework_TestCase
     */
    protected $test;

    /**
     * @param \PHPUnit_Framework_TestCase $test
     */
    public function __construct(\PHPUnit_Framework_TestCase $test)
    {
        $this->test = $test;
    }

    /**
     * @param $notifications
     * @return NotificationTemplateManagerInterface|\PHPUnit_Framework_MockObject_MockObject
     */
    public function getNotificationTemplateManagerMock($notifications)
    {
        $mock = $this->test->getMock('Application\\Core\\Model\\Manager\\NotificationTemplateManagerInterface');

        $mock->expects($this->test->any())->method('findAll')->willReturn($notifications);
        $mock->expects($this->test->any())->method('findByNotification')->willReturnCallback(
            function ($name) use ($notifications) {
                return $notifications[$name];
            }
        );

        return $mock;
    }

    /**
     * @param string $service
     * @param string $from_admin
     * @param string $to_admin
     * @param string $subject_admin
     * @param string $content_admin
     * @param string $from_user
     * @param string $to_user
     * @param string $subject_user
     * @param string $content_user
     * @return NotificationTemplateInterface|\PHPUnit_Framework_MockObject_MockObject
     */
    public function getNotificationTemplateMock($service, $from_admin, $to_admin, $subject_admin, $content_admin, $from_user, $to_user, $subject_user, $content_user)
    {
        $mock = $this->test->getMockBuilder('Application\\Core\\Model\\NotificationTemplate')
            ->disableOriginalConstructor()
            ->getMock();

        $mock->expects($this->test->any())->method('getNotificationName')->willReturn($service);
        $mock->expects($this->test->any())->method('getSenderToAdmin')->willReturn($from_admin);
        $mock->expects($this->test->any())->method('getRecipientToAdmin')->willReturn($to_admin);
        $mock->expects($this->test->any())->method('getSubjectToAdmin')->willReturn($subject_admin);
        $mock->expects($this->test->any())->method('getContentToAdmin')->willReturn($content_admin);
        $mock->expects($this->test->any())->method('getSenderToUser')->willReturn($from_user);
        $mock->expects($this->test->any())->method('getRecipientToUser')->willReturn($to_user);
        $mock->expects($this->test->any())->method('getSubjectToUser')->willReturn($subject_user);
        $mock->expects($this->test->any())->method('getContentToUser')->willReturn($content_user);
        $mock->expects($this->test->any())->method('hasTranslation')->willReturn(true); // todo: Test per quando la traduzione non esiste

        return $mock;
    }

    /**
     * @return NotificationInterface|\PHPUnit_Framework_MockObject_MockObject
     */
    public function getNotificationMock()
    {
        $mock = $this->test->getMock('Application\\Core\\Notification\\NotificationInterface');

        return $mock;
    }

    /**
     * @return NotificationTemplateGeneratorInterface|\PHPUnit_Framework_MockObject_MockObject
     */
    public function getTemplateGeneratorMock()
    {
        $mock = $this->test->getMock('Application\\Core\\Notification\\NotificationTemplateGeneratorInterface');

        return $mock;
    }

    /**
     * @return Mailer|\PHPUnit_Framework_MockObject_MockObject
     */
    public function getMailerMock()
    {
        $builder = $this->test->getMockBuilder('Application\\Core\\Utilities\\Mailer');
        $builder->setConstructorArgs(
            array(
                $this->getSiteMock(),
                $this->getLocalizationMock(),
            )
        );

        $builder->setMethods(array('send'));

        $mock = $builder->getMock();

        return $mock;
    }

    /**
     * @return Logger|\PHPUnit_Framework_MockObject_MockObject
     */
    public function getLoggerMock()
    {
        $builder = $this->test->getMockBuilder('Monolog\\Logger');
        $builder->setConstructorArgs(array('notification_logger'));

        $mock = $builder->getMock();

        return $mock;
    }

    /**
     * @return SiteInterface|\PHPUnit_Framework_MockObject_MockObject
     */
    public function getSiteMock()
    {
        $mock = $this->test->getMock('Application\\Core\\Entity\\SiteInterface');

        return $mock;
    }

    /**
     * @return AccountInterface|\PHPUnit_Framework_MockObject_MockObject
     */
    public function getAccountMock()
    {
        $account = $this->test->getMock('Application\\Core\\Entity\\AccountInterface');
        $user_details = $this->test->getMock('Application\\Core\\Entity\\UserDetailsInterface');

        $account->expects($this->test->any())->method('getUserDetails')->willReturn($user_details);

        return $account;
    }

    /**
     * @return LanguageInterface|\PHPUnit_Framework_MockObject_MockObject
     */
    public function getLanguageMock()
    {
        $mock = $this->test->getMock('Application\\Core\\Entity\\LanguageInterface');

        $mock->expects($this->test->any())->method('getId')->willReturn(1);

        return $mock;
    }

    /**
     * @return LocalizationInterface|\PHPUnit_Framework_MockObject_MockObject
     */
    public function getLocalizationMock()
    {
        $mock = $this->test->getMock('Pongho\\Core\\LocalizationInterface');

        $mock->expects($this->test->any())->method('get')->willReturnCallback(function($string) { return $string; });

        return $mock;
    }

    /**
     * @return Translator|\PHPUnit_Framework_MockObject_MockObject
     */
    public function getTranslatorMock()
    {
        $builder = $this->test->getMockBuilder('Application\\Core\\I18n\\Translation\\Translator');

        $builder->disableOriginalConstructor();

        $mock = $builder->getMock();
        $mock->expects($this->test->any())->method('trans')->willReturnCallback(function($string) { return $string; });
        $mock->expects($this->test->any())->method('get')->willReturnCallback(function($string) { return $string; });

        return $mock;
    }
}
