<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Tests\I18n\Locale\en_US;

use Application\Core\I18n\Locale\en_US\Locale;

class LocaleTest extends \PHPUnit_Framework_TestCase
{
    public function testFormatPrice()
    {
        $this->assertSame('$0.00', (new Locale())->formatPrice(0));
        $this->assertSame('0.00', (new Locale())->formatPrice(0, false));
        $this->assertSame('$0', (new Locale())->formatPrice(0, true, false));
        $this->assertSame('0', (new Locale())->formatPrice(0, false, false));

        $this->assertSame('$1.23', (new Locale())->formatPrice(1.23));
        $this->assertSame('1.23', (new Locale())->formatPrice(1.23, false));

        $this->assertSame('$1', (new Locale())->formatPrice(1.23, true, false));
        $this->assertSame('$2', (new Locale())->formatPrice(1.99, true, false));

        $this->assertSame('$1,234.56', (new Locale())->formatPrice(1234.56));
        $this->assertSame('1,234.56', (new Locale())->formatPrice(1234.56, false));
        $this->assertSame('$1,235', (new Locale())->formatPrice(1234.56, true, false));
        $this->assertSame('1,235', (new Locale())->formatPrice(1234.56, false, false));
    }

    public function testParsePrice()
    {
        $this->assertSame(0.0, (new Locale())->parsePrice('0'));
        $this->assertSame(0.0, (new Locale())->parsePrice('$0'));
        $this->assertSame(0.0, (new Locale())->parsePrice('$0.00'));
        $this->assertSame(0.0, (new Locale())->parsePrice('0$'));
        $this->assertSame(0.0, (new Locale())->parsePrice('0.00 $'));

        $this->assertSame(1234.56, (new Locale())->parsePrice('$1,234.56'));
        $this->assertSame(1234.56, (new Locale())->parsePrice('$ 1,234.56'));
        $this->assertSame(1234.56, (new Locale())->parsePrice(' $ 1,234.56'));
        $this->assertSame(1234.56, (new Locale())->parsePrice('1,234.56'));
        $this->assertSame(1234.56, (new Locale())->parsePrice('1,234.56$'));
        $this->assertSame(1234.56, (new Locale())->parsePrice('1,234.56 $'));
        $this->assertSame(1234.56, (new Locale())->parsePrice('1,234.56 $ '));
    }
}
