<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Tests\I18n\Locale;

use Application\Core\I18n\Locale\IntlLocale;

class IntlLocaleTest extends \PHPUnit_Framework_TestCase
{
    /**
     * @dataProvider pricesProvider
     *
     * @param string $localeName
     * @param string $expected
     * @param float  $price
     * @param bool   $showCurrency
     */
    public function testFormatPrice($localeName, $expected, $price, $showCurrency = true)
    {
        $this->assertSame(
            $expected,
            (new IntlLocale($localeName))->formatPrice($price, $showCurrency)
        );
    }

    /**
     * @dataProvider pricesProvider
     *
     * @param string $localeName
     * @param string $expected
     * @param float  $price
     */
    public function testParsePrice($localeName, $price, $expected)
    {
        $this->assertSame(
            (float) $expected,
            (new IntlLocale($localeName))->parsePrice($price)
        );
    }

    public function pricesProvider()
    {
        return [
            ['it_IT', '0,00 €', 0],
            ['it_IT', '0,00', 0, false],
            ['it_IT', '1,00', 1, false],
            ['it_IT', '1,23', 1.23, false],
            ['it_IT', '1.234,56 €', 1234.56],
            ['it_IT', '1.234,56', 1234.56, false],
            ['en_US', '$0.00', 0],
        ];
    }
}
