<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Tests\I18n\Country\Italy;

use Application\Core\I18n\Address\Address;
use Application\Core\I18n\Address\AddressInterface;
use Application\Core\I18n\Country\IT\AddressValidator;
use Application\Core\Model\Country;
use Application\Core\Model\Province;

class AddressValidatorTest extends \PHPUnit_Framework_TestCase
{
    /**
     * @var AddressValidator
     */
    protected $validator;

    protected function setUp()
    {
        $this->validator = new AddressValidator();
    }

    /**
     * @param AddressInterface $address
     * @param array            $expectedErrors
     *
     * @dataProvider provider
     */
    public function testValidate(AddressInterface $address, array $expectedErrors)
    {
        $errors = array();
        $this->validator->validate($address, $errors);

        $this->assertEquals($expectedErrors, $errors);
    }

    public function provider()
    {
        return array(
            array(
                new Address(),
                array(
                    'name'      => 'required_name',
                    'surname'   => 'required_surname',
                    'address'   => 'required_address',
                    'city'      => 'required_city',
                    'postcode'  => 'required_postcode',
                    'province'  => 'required_province',
                    'country'   => 'required_country',
                    'telephone' => 'required_telephone',
                )
            ),
            array(
                new Address('Paolino'),
                array(
                    'surname'   => 'required_surname',
                    'address'   => 'required_address',
                    'city'      => 'required_city',
                    'postcode'  => 'required_postcode',
                    'province'  => 'required_province',
                    'country'   => 'required_country',
                    'telephone' => 'required_telephone',
                )
            ),
            array(
                new Address('Paolino', 'Paperino'),
                array(
                    'address'   => 'required_address',
                    'city'      => 'required_city',
                    'postcode'  => 'required_postcode',
                    'province'  => 'required_province',
                    'country'   => 'required_country',
                    'telephone' => 'required_telephone',
                )
            ),
            array(
                new Address(
                    'Paolino',
                    'Paperino',
                    '',
                    'via Marconi, 56',
                    '',
                    '00123',
                    'Roma',
                    $this->getProvinceMock(),
                    $this->getCountryMock(),
                    '123456'
                ),
                array()
            ),
            array(
                new Address(
                    'Paolino',
                    'Paperino',
                    '',
                    'via Marconi, 56',
                    '',
                    123,
                    'Roma',
                    $this->getProvinceMock(),
                    $this->getCountryMock(),
                    '123456'
                ),
                array(
                    'postcode' => 'invalid_postcode_format',
                )
            ),
        );
    }

    /**
     * @return Province
     */
    protected function getProvinceMock()
    {
        $province = $this->getMockBuilder(Province::class)
            ->disableOriginalConstructor()
            ->setMethods(array('__wakeup'))
            ->getMock();

        /**
         * @var Province $province
         */

        return $province;
    }

    /**
     * @return Country
     */
    protected function getCountryMock()
    {
        $country = $this->getMockBuilder(Country::class)
            ->disableOriginalConstructor()
            ->setMethods(array('__wakeup'))
            ->getMock();

        /**
         * @var Country $country
         */

        return $country;
    }
}
