<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Tests\Export\Serializer;

use Application\Core\Export\DataExporterInterface;
use Application\Core\Export\Serializer\CsvSerializer;

class CsvSerializerTest extends \PHPUnit_Framework_TestCase
{
    public function testSerialize()
    {
        $exporter = $this->getMock(DataExporterInterface::class);

        $exporter->method('headers')->willReturn(['Name', 'Surname']);
        $exporter->method('export')->willReturn([
            ['John', 'Doe'],
            ['Aulo', 'Agerio'],
            ['Numerio', 'Negidio'],
        ]);

        /**
         * @var DataExporterInterface $exporter
         */

        $serializer = new CsvSerializer();

        $response = $serializer->serialize($exporter, 'export.csv');
        $csv = "Name,Surname\nJohn,Doe\nAulo,Agerio\nNumerio,Negidio\n";
        $this->assertEquals($csv, $response->getContent());
    }

    public function testCsvControl()
    {
        $exporter = $this->getMock(DataExporterInterface::class);

        $exporter->method('headers')->willReturn(['Fullname', 'E-mail', 'Special']);
        $exporter->method('export')->willReturn([
            ['John Doe', 'john@example.com', '"'],
            ['Aulo Agerio', 'aulo@example.com', ''],
            ['Numerio Negidio', 'numerio@example.com', "'"],
        ]);

        /**
         * @var DataExporterInterface $exporter
         */

        $serializer = new CsvSerializer();

        $response = $serializer->serialize($exporter, 'export.csv');
        $csv = "Fullname,E-mail,Special\n\"John Doe\",john@example.com,\"\"\"\"\n\"Aulo Agerio\",aulo@example.com,\n\"Numerio Negidio\",numerio@example.com,'\n";
        $this->assertEquals($csv, $response->getContent());

        $serializer->setCsvControl(';', "'");
        $response = $serializer->serialize($exporter, 'export.csv');
        $csv = "Fullname;E-mail;Special\n'John Doe';john@example.com;\"\n'Aulo Agerio';aulo@example.com;\n'Numerio Negidio';numerio@example.com;''''\n";
        $this->assertEquals($csv, $response->getContent());
    }
}
