<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Routes;

use Pongho\Core\Kernel;
use Pongho\Http\Request;
use Pongho\Routing\RouteInterface;

/**
 * ModulesRoute
 */
class ModulesRoute implements RouteInterface
{
    /**
     * @var \Application\Core\Model\ModuleSite
     */
    protected $module;

    /**
     * @var \Application\Core\Model\LanguageSite
     */
    protected $language;

    /**
     * @var string
     */
    protected $action = 'index';

    /**
     * @var int
     */
    protected $id;

    /**
     * {@inheritdoc}
     */
    public function match(Request $request)
    {
        /** @var \Application\Core\Model\Site $site */
        $site = Kernel::instance()->getContainer()->get('site');

        foreach ($site->getLanguagesModules() as $language_module) {
            if ($request->getPathInfo() == $language_module->path) {
                $this->module = $language_module->getSiteModule();
                $this->language = $language_module->getSiteLanguage();
                $this->action = 'index';

                break;
            }
        }

        if ($this->module !== null) {
            return true;
        }

        foreach ($site->getLanguagesModules() as $language_module) {
            if (strpos($request->getPathInfo(), $language_module->path) === 0) {
                $this->module = $language_module->getSiteModule();
                $this->language = $language_module->getSiteLanguage();

                $segments = explode('/', substr($request->getPathInfo(), strlen($language_module->path)));

                if (isset($segments[0])) {
                    $this->action = $segments[0];

                    if (isset($segments[1])) {
                        $this->id = $segments[1];
                    }
                }

                break;
            }
        }

        if ($this->module === null) {
            return false;
        }

        return true;
    }

    /**
     * {@inheritdoc}
     */
    public function getController()
    {
        return $this->module->controller;
    }

    /**
     * {@inheritdoc}
     */
    public function getAction()
    {
        return $this->action;
    }

    /**
     * {@inheritdoc}
     */
    public function getParameters()
    {
        return array(
            'site_module'   => $this->module,
            'site_language' => $this->language,
            'id'            => $this->id,
        );
    }
}
