<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Routes;

use Pongho\Http\Request;
use Pongho\Routing\RouteInterface;

/**
 * ApiRoute
 */
class ApiRoute implements RouteInterface
{
    /**
     * @var string
     */
    protected $controller;

    /**
     * @var string
     */
    protected $action = 'index';

    /**
     * @var string
     */
    protected $command;

    /**
     * @var string
     */
    protected $format = 'html';

    /**
     * @var array
     */
    protected $valid_formats = array('html', 'json', 'xml');

    /**
     * {@inheritdoc}
     */
    public function match(Request $request)
    {
        $path_info = $request->getPathInfo();

        if (($pos = strrpos($path_info, '.')) !== false) {
            $format = substr($path_info, $pos + 1);

            if (in_array($format, $this->valid_formats)) {
                $this->format = $format;

                $path_info = substr($path_info, 0, $pos);
            }
        }

        if (strpos($path_info, '/api/') === 0) {
            $path = substr($path_info, 5); // rimuovo il pezzo '/api/', 5 caratteri

            $segments = explode('/', trim($path, '/'));

            if (($app = array_shift($segments)) === null) {
                return false;
            }

            if ($app === 'custom') {
                if (($app = array_shift($segments)) === null) {
                    return false;
                }

                $controllerClass = 'Plugins\\' . ucfirst($app) . '\\ApiController';
            } else {
                $controllerClass = 'Application\\' . ucfirst($app) . '\\Controller\\ApiController';
            }

            if (!class_exists($controllerClass)) {
                return false;
            }

            $this->controller = $controllerClass;

            if (($action = array_shift($segments)) !== null) {
                $this->action = $action;
            }

            $this->command = trim(implode('/', $segments), '/');

            return true;
        }

        return false;
    }

    /**
     * {@inheritdoc}
     */
    public function getController()
    {
        return $this->controller;
    }

    /**
     * {@inheritdoc}
     */
    public function getAction()
    {
        return $this->action;
    }

    /**
     * {@inheritdoc}
     */
    public function getParameters()
    {
        return array(
            'command' => $this->command,
            'format'  => $this->format,
        );
    }
}
