<?php

/**
 * @var \Application\Core\Utilities\Html $html
 * @var \Application\Core\Model\Site     $site
 * @var string                           $action_form
 * @var string                           $value_slogan
 * @var string                           $value_subscription_mode
 * @var string                           $value_account_url
 * @var string                           $value_recaptcha
 * @var string                           $value_recaptcha_private_key
 * @var string                           $value_recaptcha_public_key
 * @var string                           $value_recaptcha2_private_key
 * @var string                           $value_recaptcha2_public_key
 * @var string                           $value_recaptcha2_labs_private_key
 * @var string                           $value_recaptcha2_labs_public_key
 * @var string                           $value_google_maps_api_key
 */

?>
<form action="<?= $action_form; ?>" method="post" class="section checksave">

    <h2>Opzioni</h2>

    <?php

    include 'messages.php';
    include 'tabs.php';

    ?>

    <div class="tabsPanel" id="panel-main">
        <fieldset class="panel">
            <h3>Configurazione del sito</h3>
            <dl class="extend">
                <dt><label for="field-site-name">Nome</label></dt>
                <dd><input type="text" name="site[name]" id="field-site-name" value="<?= $site->name; ?>" class="input_text"/></dd>
            </dl>

            <dl class="extend">
                <dt><label for="field-slogan">Slogan</label></dt>
                <dd><input type="text" name="options[slogan]" id="field-slogan" value="<?= $value_slogan; ?>" class="input_text"/></dd>
            </dl>

            <dl class="extend">
                <dt><label for="field-site-domain">Dominio</label></dt>
                <dd><input type="text" name="site[domain]" id="field-site-domain" value="<?= $site->domain; ?>" class="input_text"/></dd>
            </dl>

            <dl class="extend">
                <dt><label for="field-default-language">Lingua principale</label>
                </dt>
                <dd>
                    <select name="site[default_language_id]" id="field-default-language">
                        <?= $html->selectLanguage($site->default_language_id); ?>
                    </select>
                    <span>Indica quale lingua utilizzare se nessuno dei 3 parametri (url della pagina, configurazione utente e browser) riescono a definire la lingua da utilizzare.</span>
                </dd>
            </dl>
        </fieldset>

        <fieldset class="panel">
            <h3>Configurazione utenti</h3>
            <dl class="extend">
                <dt><label for="field-subscription-mode">Modalità di iscrizione</label>
                </dt>
                <dd>
                    <select name="options[subscription_mode]" id="field-subscription-mode">
                        <?php

                        echo $html->select(
                            [
                                'simple' => 'Iscrizione semplice',
                                'email'  => 'Iscrizione tramite email di attivazione',
                                'admin'  => 'Iscrizione con attivazione da amministrazione',
                            ],
                            $value_subscription_mode
                        );

                        ?>
                    </select>
                </dd>
            </dl>

            <dl class="extend">
                <dt><label for="field-account_url">Url profilo pubblico</label></dt>
                <dd>
                    <input type="checkbox" name="options[account_url]" id="field-account_url"<?= $value_account_url ? ' checked="checked"' : ''; ?>>
                    <span>Abilita l’url per il profilo pubblico degli utenti</span>
                </dd>
            </dl>
        </fieldset>

        <fieldset class="panel">
            <h3>reCAPTCHA</h3>
            <dl class="extend">
                <dt><label for="field-recaptcha">reCAPTCHA</label></dt>
                <dd>
                    <input type="checkbox" name="options[recaptcha]" id="field-recaptcha"<?= $value_recaptcha ? ' checked="checked"' : ''; ?>>
                    <span>Abilita l’utilizzo di reCAPTCHA</span>
                </dd>
            </dl>

            <dl class="extend">
                <dt><label for="field-recaptcha-private-key">Chiave privata</label></dt>
                <dd>
                    <input type="text" name="options[recaptcha_private_key]" id="field-recaptcha-private-key" value="<?= $value_recaptcha_private_key; ?>" class="input_text"/>
                    <span>Chiavi di default globali (multi dominio) Meta Line, qualora si rendesse necessario modificare le chiavi o usare delle chiavi specifiche per un sito, l'amministrazione di reCAPTCHA la puoi trovare al seguente indirizzo: <a href="https://www.google.com/recaptcha/admin/list" target="_blank">https://www.google.com/recaptcha/admin/list</a></span>
                </dd>
            </dl>

            <dl class="extend">
                <dt><label for="field-recaptcha-public-key">Chiave pubblica</label></dt>
                <dd><input type="text" name="options[recaptcha_public_key]" id="field-recaptcha-public-key" value="<?= $value_recaptcha_public_key; ?>" class="input_text"/></dd>
            </dl>
        </fieldset>

        <fieldset class="panel">
            <h3>reCAPTCHA2 - Chiave specifica per il sito</h3>

            <dl class="extend">
                <dt><label for="field-recaptcha2-private-key">Chiave privata</label></dt>
                <dd><input type="text" name="options[recaptcha2_private_key]" id="field-recaptcha-private-key" value="<?= $value_recaptcha2_private_key; ?>" class="input_text"/></dd>
            </dl>

            <dl class="extend">
                <dt><label for="field-recaptcha2-public-key">Chiave pubblica</label></dt>
                <dd><input type="text" name="options[recaptcha2_public_key]" id="field-recaptcha-public-key" value="<?= $value_recaptcha2_public_key; ?>" class="input_text"/></dd>
            </dl>

            <h3>reCAPTCHA2 - Chiavi di default per Labs</h3>
            <dl class="extend">
                <dt><label for="field-recaptcha2-labs-private-key">Chiave privata</label></dt>
                <dd><input type="text" name="options[recaptcha2_labs_private_key]" id="field-recaptcha-private-key" value="<?= $value_recaptcha2_labs_private_key; ?>" class="input_text"/></dd>
            </dl>

            <dl class="extend">
                <dt><label for="field-recaptcha2-labs-public-key">Chiave pubblica</label></dt>
                <dd><input type="text" name="options[recaptcha2_labs_public_key]" id="field-recaptcha-public-key" value="<?= $value_recaptcha2_labs_public_key; ?>" class="input_text"/></dd>
            </dl>
        </fieldset>
        <fieldset class="panel">
            <h3>Google Maps</h3>
            <dl class="extend">
                <dt><label for="field-google-maps-api-key">API Key</label></dt>
                <dd><input type="text" name="options[google_maps_api_key]" id="field-google-maps-api-key" value="<?= $value_google_maps_api_key; ?>" class="input_text"/></dd>
            </dl>
        </fieldset>
    </div>

    <fieldset class="btn">
        <input type="submit" value="Salva" class="primary"/>
    </fieldset>

</form><!-- .section -->
