<?php

/**
 * @var \Application\Core\I18n\Translation\Translator $translator
 * @var string                                        $action_form
 * @var string                                        $value_gapi_email
 * @var string                                        $value_gapi_view_id
 */

?>
<form action="<?= $action_form ?>" method="post" class="section">

    <h2>Opzioni</h2>

    <?php

    include 'messages.php';
    include 'tabs.php';

    ?>

    <div class="tabsPanel" id="panel-dashboard">
        <fieldset class="panel">
            <h3 style="margin-bottom: 8px;"><?= $translator->trans('Google Analytics API'); ?></h3>
            <p style="margin-bottom: 16px; padding: 0;">
                <?= $translator->trans('Le Api di Google Analytics vengono usate nella bacheca per visualizzare le statistiche principali del sito. È necessario indicare l’indirizzo e-mail e la password dell’account Google legato al sito e l’ID profilo del sito. Per conoscere quest’ultimo è necessario accedere a Google Analytics, cliccare su “Amministrazione” in alto a destra, selezionare il sito, entrare nel pannello “Profili” ? “Impostazioni profilo” e copiare il campo “ID Profilo”.') ?>
            </p>

            <dl class="extend">
                <dt><label for="field-gapi-email"><?= $translator->trans('E-mail address'); ?></label></dt>
                <dd><input type="text" name="options[gapi_email]" id="field-gapi-email" value="<?= $value_gapi_email ?>" class="input_text"/></dd>
            </dl>

            <dl class="extend">
                <dt><label for="field-gapi-view-id"><?= $translator->trans('View ID'); ?></label></dt>
                <dd><input type="text" name="options[gapi_view_id]" id="field-gapi-view-id" value="<?= $value_gapi_view_id ?>" class="input_text"/></dd>
            </dl>
        </fieldset>
    </div>

    <fieldset class="btn">
        <input type="submit" value="<?= $lang->get('save'); // TODO: Translation  ?>" class="primary"/>
    </fieldset>

</form><!-- .section -->
