<?php

/**
 * @var \Application\Core\Utilities\Html       $html
 * @var string                                 $action_form
 * @var \Application\Core\Model\Site           $site
 * @var \Application\Core\Model\LanguageSite[] $rows
 * @var array                                  $languages
 */

?>
<form action="<?= $action_form ?>" method="post" class="section checksave">

	<h2>Gestione lingue</h2>

	<?php

	include 'messages.php';
	include 'tabs.php';

	?>

	<fieldset class="panel">
		<p>Lingue abilitate per il sito <strong><?= $site->name; ?></strong></p>

		<table class="pongho-table">
			<thead>
				<tr>
					<th class="main">Lingua</th>
					<th>Percorso</th>
					<th>Abilitato</th>
				</tr>
			</thead>
			<tfoot>
				<tr>
					<th class="main">Lingua</th>
					<th>Percorso</th>
					<th>Abilitato</th>
				</tr>
			</tfoot>

			<tbody>
				<?php foreach ($rows as $row): ?>
					<tr>
						<td class="main">
							<img class="flag" src="<?= pongho_url("/Application/Core/Resources/flags/16/{$row->culture}.png"); ?>" alt="<?= $row->iso; ?>" title="<?= $row->name; ?>">
							<input type="hidden" name="languages[<?= $row->language_id ?>][language_id]" value="<?= $row->language_id; ?>" />
							<?= $row->name; ?>
						</td>
						<td><?= $row->path ?></td>
						<td><input type="checkbox" name="languages[<?= $row->language_id ?>][is_enabled]" <?= $row->is_enabled ? ' checked="checked"' : ''?> ></td>
					</tr>
				<?php endforeach; ?>

				<tr class="clonable">
					<td class="main"><select name="languages[new][language_id]"><option value=""></option><?= $html->select($languages); ?></select></td>
					<td><input type="text" name="languages[new][path]" value="" class="input_text" style="width: 150px;"></td>
					<td><input type="checkbox" name="languages[new][is_enabled]"></td>
				</tr>
			</tbody>
		</table>
	</fieldset><!-- .panel -->

	<fieldset class="btn">
		<input type="submit" value="Salva" class="primary" />
	</fieldset>

</form><!-- .section -->
