<?php

/**
 * @var string                          $add_url
 * @var string                          $mass_action_url
 * @var string                          $mass_action_buttons
 * @var \Application\Core\Model\Group[] $rows
 */

?>
<div class="section">

    <h2>Gestione gruppi utente</h2>

    <div class="panel">
        <p>I gruppi permettono di dividere gli utenti in modo da agevolare le operazioni di massa,
            come l’invio delle newsletter.</p>

        <div class="btn"><a href="<?= $add_url ?>" class="primary">Crea gruppo</a></div>

        <form action="<?= $mass_action_url ?>" method="post" class="clr">
            <table class="pongho-table">
                <thead>
                <tr>
                    <th class="ckb"><input type="checkbox"/></th>
                    <th class="main">Gruppo</th>
                    <th class="largest">Descrizione</th>
                </tr>
                </thead>
                <tfoot>
                <tr>
                    <th class="ckb"><input type="checkbox"/></th>
                    <th class="main">Gruppo</th>
                    <th class="largest">Descrizione</th>
                </tr>
                </tfoot>
                <tbody>
                <?php if (empty($rows)): ?>
                    <tr>
                        <td colspan="3" class="empty">
                            <a href="<?= $add_url ?>">Crea il primo gruppo di utenti</a>
                        </td>
                    </tr>
                <?php else: foreach ($rows as $row): ?>
                    <tr>
                        <td class="ckb"><input type="checkbox" name="ids[<?= $row->id ?>]"/></td>
                        <td class="main">
                            <strong><?= $row->name ?></strong>
                            <div class="actions"><span><?= $row->actions ?></span></div>
                        </td>
                        <td class="largest"><?= $row->description ?></td>
                    </tr>
                <?php endforeach; endif; ?>
                </tbody>
            </table>

            <div class="btn">
                <?= $mass_action_buttons ?>
            </div>
        </form>

    </div><!-- .panel -->

</div><!-- .section -->
