<?php

/**
 * @var \Application\Core\I18n\Translation\Translator $translator
 * @var \Application\Core\Model\Account              $account
 * @var string                                       $form_action
 * @var string                                       $base_url
 */

$explain = $translator->trans(
    '<p>Edit the url to access the user’s public profile.<br>The url can be modified only once, choose it with care.<br>The url must be unique, if another user has already chosen the url you want, you must choose a different one.<br>Only lowercase letters, numbers and the hyphen are allowed, the url must not start with a number.<br>The `Verify` function will check the url validity and will remove any not allowed character.</p>'
);

?>
<div id="account-url-edit" class="panel">
    <div id="account-url-description">
        <?php echo $explain; ?>
    </div>

    <form id="account-url-form" action="<?php echo $form_action; ?>" method="post" class="pongho-form-basic">
        <div id="account-url-errors"></div>
        <div class="control-group">
            <label class="control-label" for="account-url"><?php echo $translator->trans('Url'); ?>*</label>
            <div class="controls">
                <?php echo $base_url; ?><input id="account-url" required name="url" class="input_text" value="<?php echo $account->url; ?>">
            </div>
        </div>
        <div class="actions">
            <button id="account-url-preview" class="pongho-button" name="preview"><?php echo $translator->trans('Verify'); ?></button>
            <button id="account-url-confirm" class="pongho-button" name="confirm" style="display:none;"><?php echo $translator->trans('Confirm'); ?></button>
        </div>
    </form>
</div>
