/**
 * cookieManager.js
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 */

/*jslint nomen: true, plusplus: true, passfail: true, browser: true, devel: true */

(function (d, w) {
    "use strict";

    w.cookieManager = {
        create: function (name, value, days) {
            var date, expires = '';

            if (days) {
                date = new Date();
                date.setTime(date.getTime() + (days * 86400000)); // 24 * 60 * 60 * 1000
                expires = "; expires=" + date.toUTCString();
            }

            d.cookie = name + '=' + value + expires + '; path=/';
        },
        read: function (name) {
            var
                nameEQ = name + '=',
                ca = d.cookie.split(';'),
                i, l = ca.length, c;

            for (i = 0; i < l; i++) {
                c = ca[i];

                while (c.charAt(0) === ' ') {
                    c = c.substring(1, c.length);
                }

                if (c.indexOf(nameEQ) === 0) {
                    return c.substring(nameEQ.length, c.length);
                }
            }

            return null;
        },
        erase: function (name) {
            this.create(name, '', -1);
        }
    };
}(document, window));
