<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Notification;

use Application\Core\Entity\LanguageInterface;

/**
 * UserSubscribeNotification.
 */
abstract class UserSubscribeNotification extends AbstractNotification
{
    use HasAccountTrait, HasPasswordTrait, HasSettingsLinkTrait;

    /**
     * {@inheritdoc}
     */
    public function getOptions()
    {
        if ($this->options === null) {
            $this->options = new NotificationOptions(true, true, false, true, true, false);
        }

        return $this->options;
    }

    /**
     * @return LanguageInterface
     */
    public function getLanguage()
    {
        return $this->account->getLanguage();
    }

    /**
     * {@inheritdoc}
     */
    public function getVars()
    {
        $vars = parent::getVars();

        $vars[] = 'USER_USERNAME';
        $vars[] = 'USER_EMAIL';
        $vars[] = 'USER_FULL_NAME';
        $vars[] = 'USER_PASSWORD';
        $vars[] = 'USER_SETTINGS_LINK';

        $vars[] = 'USER_FIRST_NAME';
        $vars[] = 'USER_LAST_NAME';

        $vars[] = 'USER_ADDRESS';
        $vars[] = 'USER_CITY';
        $vars[] = 'USER_POSTCODE';
        $vars[] = 'USER_PROVINCE';
        $vars[] = 'USER_PROVINCE_PLATE';
        $vars[] = 'USER_COUNTRY';

        $vars[] = 'USER_COMPANY';
        $vars[] = 'USER_VAT_NUMBER';
        $vars[] = 'USER_TAX_CODE';

        $vars[] = 'USER_WEBSITE';
        $vars[] = 'USER_TELEPHONE';
        $vars[] = 'USER_FAX';

        return $vars;
    }

    /**
     * {@inheritdoc}
     */
    public function getEmailVars()
    {
        $vars = parent::getEmailVars();

        $account = $this->getAccount();

        $vars['USER_USERNAME'] = $account->getUsername();
        $vars['USER_EMAIL'] = $account->getEmail();
        $vars['USER_FULL_NAME'] = $account->getUserDetails()->name();
        $vars['USER_PASSWORD'] = $this->getPassword();
        $vars['USER_SETTINGS_LINK'] = $this->getSettingsLink();

        $vars['USER_FIRST_NAME'] = $account->getUserDetails()->getName();
        $vars['USER_LAST_NAME'] = $account->getUserDetails()->getSurname();

        $vars['USER_ADDRESS'] = $account->getUserDetails()->getAddress();
        $vars['USER_CITY'] = $account->getUserDetails()->getCity();
        $vars['USER_POSTCODE'] = $account->getUserDetails()->getPostCode();

        $province = $account->getUserDetails()->getProvince();
        $vars['USER_PROVINCE'] = $province ? $province->getName() : '';
        $vars['USER_PROVINCE_PLATE'] = $province ? $province->getPlate() : '';

        $country = $account->getUserDetails()->getCountry();
        $vars['USER_COUNTRY'] = $country ? $country->getName() : '';

        $vars['USER_COMPANY'] = $account->getUserDetails()->getCompany();
        $vars['USER_VAT_NUMBER'] = $account->getUserDetails()->getVatNumber();
        $vars['USER_TAX_CODE'] = $account->getUserDetails()->getTaxCode();

        $vars['USER_WEBSITE'] = $account->getUserDetails()->getWebsite();
        $vars['USER_TELEPHONE'] = $account->getUserDetails()->getTelephone();
        $vars['USER_FAX'] = $account->getUserDetails()->getFax();

        return $vars;
    }
}
