<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Notification;

/**
 * UserActivatedNotification.
 *
 * Viene inviata all’utente quando l’iscrizione deve essere accettata
 * dall'amministratore e viene spuntata la flag della notifica "Cambio stato".
 */
class UserActivatedNotification extends AbstractNotification
{
    use HasAccountTrait, HasPasswordTrait;

    /**
     * {@inheritdoc}
     */
    public function getName()
    {
        return 'core.user_activated';
    }

    /**
     * {@inheritdoc}
     */
    public function getTitle()
    {
        return $this->translator->trans('User has been activated');
    }

    /**
     * {@inheritdoc}
     */
    public function getOptions()
    {
        if ($this->options === null) {
            $this->options = new NotificationOptions(false, true, false, true, true, false);
        }

        return $this->options;
    }

    /**
     * {@inheritdoc}
     */
    public function getLanguage()
    {
        return $this->getAccount()->getLanguage();
    }

    /**
     * {@inheritdoc}
     */
    public function getVars()
    {
        $vars = parent::getVars();

        $vars[] = 'USER_USERNAME';
        $vars[] = 'USER_EMAIL';
        $vars[] = 'USER_FULL_NAME';
        $vars[] = 'USER_PASSWORD';

        return $vars;
    }

    /**
     * {@inheritdoc}
     */
    public function getEmailVars()
    {
        $vars = parent::getEmailVars();

        $vars['USER_USERNAME'] = $this->getAccount()->getUsername();
        $vars['USER_EMAIL'] = $this->getAccount()->getEmail();
        $vars['USER_FULL_NAME'] = $this->getAccount()->getUserDetails()->name();
        $vars['USER_PASSWORD'] = $this->getPassword();

        return $vars;
    }
}
