<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Notification;

use Application\Core\Entity\LanguageInterface;
use Application\Core\Entity\NotificationTemplateInterface;

/**
 * Interface NotificationInterface
 */
interface NotificationInterface
{
    /**
     * Il nome della notifica da registrare nella collection, deve essere univoco per ogni notifica
     *
     * @return string
     */
    public function getName();

    /**
     * Restituisce il titolo tradotto per la notifica
     *
     * @return string
     */
    public function getTitle();

    /**
     * Opzioni per gestire la personalizzazione del template in amministrazione
     *
     * Indica al controller che gestisce la form per la personalizzazione del template quali campi sono modificabili.
     * Es: nell'email all'utente non sarà possibile modificare il campo "To:" ma sarà possibile
     * modificare il campo "From:", invece nell'email all'amministratore sarà possibile modificare anche il campo
     * "To:" per consentire destinatari multipli. Altre notifiche non avranno la parte di notifica all'utente o
     * all'amministratore (ad esempio recupero password)
     *
     * @return NotificationOptions
     */
    public function getOptions();

    /**
     * Restituisce un elenco di chiavi da poter utilizzare nel template per inserire i valori dinamici
     *
     * @return array
     */
    public function getVars();

    /**
     * Restituisce un array hash di valori le cui chiavi devono essere le stesse dell'array restituito dall'altra funzione
     *
     * @return array
     */
    public function getEmailVars();

    /**
     * @return LanguageInterface
     */
    public function getLanguage();

    /**
     * Restituisce il template di default, che può essere personalizzato, da usare per l'invio
     *
     * @return NotificationTemplateInterface
     */
    public function getDefaultTemplate();
}
