<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Notification;

/**
 * HasPasswordTrait.
 */
trait HasPasswordTrait
{
    /**
     * @var string
     */
    protected $password;

    /**
     * @return string
     */
    public function getPassword()
    {
        if ($this->password === null) {
            throw new \BadMethodCallException('You first need to set the password!');
        }

        return $this->password;
    }

    /**
     * @param string $password
     * @return $this
     */
    public function setPassword($password)
    {
        $this->password = $password;
        
        return $this;
    }
}
