<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Notification;

use Application\Core\Entity\AccountInterface;

/**
 * HasAccountTrait.
 */
trait HasAccountTrait
{
    /**
     * @var AccountInterface
     */
    protected $account;

    /**
     * @return AccountInterface
     */
    public function getAccount()
    {
        if ($this->account === null) {
            throw new \BadMethodCallException('You first need to set the account!');
        }

        return $this->account;
    }

    /**
     * @param AccountInterface $account
     * @return $this
     */
    public function setAccount(AccountInterface $account)
    {
        $this->account = $account;

        return $this;
    }
}
