<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Model;

use ActiveRecord\Base;
use Application\Core\Entity\RegionInterface;
use Pongho\Core\Kernel;

/**
 * Modello per le regioni.
 *
 * @property int    $id
 * @property string $name
 * @property string $name_long
 * @property string $url
 */
class Region extends Base implements RegionInterface
{
    /**
     * Nome della tabella.
     *
     * @var string
     */
    public static $table_name = 'regions';

    /**
     * __toString
     *
     * @return string
     */
    public function __toString()
    {
        return $this->name;
    }

    /**
     * {@inheritdoc}
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * {@inheritdoc}
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * {@inheritdoc}
     */
    public function getLongName()
    {
        return $this->name_long;
    }

    /**
     * {@inheritdoc}
     */
    public function getSlug()
    {
        return $this->url;
    }

    /**
     * {@inheritdoc}
     */
    public function getProvinces()
    {
        /** @var Manager\ProvinceManager $manager */
        $manager = Kernel::instance()->getContainer()->get('province_manager');

        return $manager->findByRegion($this->id);
    }
}
