<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Model\Manager;

use Application\Core\Entity\LanguageInterface;
use Application\Core\Entity\SiteInterface;

/**
 * Interface SiteManagerInterface
 */
interface SiteManagerInterface
{
    /**
     * @param int $site_id
     * @return SiteInterface
     */
    public function findById($site_id);

    /**
     * @return SiteInterface[]
     */
    public function findAll();

    /**
     * @return SiteInterface
     */
    public function getMainSite();

    /**
     * @param string                $name
     * @param string                $domain
     * @param int|LanguageInterface $default_language_id
     * @param string                $images_url
     * @param string                $uploads_url
     * @param string                $themes_url
     * @param string                $content_path
     * @param string                $images_path
     * @param string                $uploads_path
     * @param string                $themes_path
     * @param array                 $settings
     * @return SiteInterface
     */
    public function create($name, $domain, $default_language_id, $images_url, $uploads_url, $themes_url, $content_path = '/content', $images_path = '/content/images', $uploads_path = '/content/uploads', $themes_path = '/content/themes', array $settings = array());

    /**
     * @param SiteInterface $site
     * @return SiteInterface
     */
    public function save(SiteInterface $site);
}
