<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Model\Manager;

use Application\Core\Entity\RegionInterface;
use Application\Core\Model\Province;

/**
 * Class ProvinceManager
 */
class ProvinceManager implements ProvinceManagerInterface
{
    /**
     * @var Province[]
     */
    protected $models;

    /**
     * @param int $id
     * @return Province
     */
    public function findById($id)
    {
        $this->prepare();

        if (array_key_exists($id, $this->models)) {
            return $this->models[$id];
        }

        return null;
    }

    /**
     * @param string $plate
     * @return Province
     */
    public function findByPlate($plate)
    {
        $models = array_filter(
            $this->findAll(),
            function (Province $model) use ($plate) {
                if ($model->getPlate() !== $plate) {
                    return false;
                }

                return true;
            }
        );

        if (!empty($models)) {
            return reset($models);
        }

        return null;
    }

    /**
     * @return Province[]
     */
    public function findAll()
    {
        $this->prepare();

        return $this->models;
    }

    /**
     * @param int|RegionInterface $region
     * @return Province[]
     */
    public function findByRegion($region)
    {
        if (is_numeric($region)) {
            $region_id = intval($region);
        } else {
            $region_id = $region->getId();
        }

        $models = array_filter(
            $this->findAll(),
            function (Province $model) use ($region_id) {
                if ($model->getRegionId() !== $region_id) {
                    return false;
                }

                return true;
            }
        );

        return $models;
    }

    /**
     * Precarica le province
     */
    protected function prepare()
    {
        if ($this->models === null) {
            $this->models = array();

            /** @var Province $province */
            foreach (Province::all(array('order' => 'name ASC')) as $province) {
                $this->models[$province->getId()] = $province;
            }
        }
    }
}
