<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Model\Manager;

use Application\Core\Entity\AccountInterface;
use Application\Core\Entity\UserDetailsInterface;

/**
 * Interface AccountManagerInterface
 */
interface AccountManagerInterface
{
    /**
     * @param int $id
     * @return AccountInterface|UserDetailsInterface
     */
    public function findById($id);

    /**
     * @param string $email
     * @return AccountInterface|UserDetailsInterface
     */
    public function findByEmail($email);

    /**
     * @param string $username
     * @return AccountInterface|UserDetailsInterface
     */
    public function findByUsername($username);

    /**
     * @param string $token
     * @return AccountInterface|UserDetailsInterface
     */
    public function findByResetPasswordToken($token);

    /**
     * @param string $url
     * @return AccountInterface|UserDetailsInterface
     */
    public function findByUrl($url);

    /**
     * @param int|AccountInterface $descendant
     * @param int|AccountInterface $current_account
     * @param bool                 $can_view_all_users
     * @return mixed
     */
    public function findAncestorsByDescendant($descendant, $current_account = null, $can_view_all_users = true);

    /**
     * @param array $ids
     * @return \Application\Core\Model\Account[]
     */
    public function findAllByIds(array $ids);

    /**
     * @param string $permissionKey
     * @param string $orderBy
     * @param int    $limit
     * @param int    $offset
     * @return \Application\Core\Model\Account[]
     */
    public function findAllByPermission($permissionKey, $orderBy = null, $limit = 50, $offset = 0);

    /**
     * Search accounts by a keyword.
     *
     * The second arguments is an array of options:
     * - searchableFields: The list of searchable fields, default ['email', 'username', 'name', 'surname', 'company']
     * - active: If the accounts must be active, default true
     * - founder: If the accounts should be founder, default false
     *
     * @param string $keyword
     * @param array  $options
     * @param string $orderBy
     * @param int    $limit
     * @param int    $offset
     * @return \Application\Core\Model\Account[]
     */
    public function search($keyword, array $options = [], $orderBy = null, $limit = 50, $offset = 0);

    /**
     * @param AccountInterface $account
     */
    public function save(AccountInterface $account);
}
