<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Model\Manager;

/**
 * Class AbstractCoreManager
 */
abstract class AbstractCoreManager
{
    /**
     * @var CoreManagerRegistry
     */
    protected $registry;

    /**
     * @param CoreManagerRegistry $registry
     */
    public function __construct(CoreManagerRegistry $registry)
    {
        $this->registry = $registry;
    }

    /**
     * @return CoreManagerRegistryCache
     */
    protected function getCache()
    {
        return $this->registry->getCache();
    }
}
