<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Model;

use ActiveRecord\Base;

/**
 * Modello per le relazioni tra account e gruppi.
 *
 * @property int     $group_id
 * @property int     $user_id
 * @property Account $user
 */
class GroupUser extends Base
{
    /**
     * Nome della tabella.
     *
     * @var string
     */
    public static $table_name = 'groups_users';

    /**
     * Chiave primaria.
     *
     * @var array
     */
    public static $primary_key = ['group_id', 'user_id'];

    /**
     * Relazioni 'belongs_to'.
     *
     * @var array
     */
    public static $belongs_to = [
        ['user', 'model' => Account::class],
    ];
}
