<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author Daniele Termini
 * @package Application\Core
 */

namespace Application\Core\LinkType;

use Traversable;

class LinkHandlerCollection implements \IteratorAggregate
{
    /**
     * @var LinkHandlerInterface[]
     */
    protected $collection = array();

    /**
     * @var string
     */
    protected $name;

    /**
     * @var int
     */
    protected $language_id;

    /**
     * @param string $name
     * @param int    $language_id
     */
    public function __construct($name = '', $language_id = null)
    {
        $this->name = $name;
        $this->language_id = $language_id;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @return int
     */
    public function getLanguageId()
    {
        return $this->language_id;
    }

    /**
     * @param LinkHandlerInterface $handler
     */
    public function add(LinkHandlerInterface $handler)
    {
        $this->collection[$handler->getName()] = $handler;
    }

    /**
     * @return LinkHandlerInterface[]
     */
    public function all()
    {
        return $this->collection;
    }

    /**
     * @param $name
     * @return bool
     */
    public function has($name)
    {
        return isset($this->collection[$name]);
    }

    /**
     * @param string $name
     * @return LinkHandlerInterface|null
     */
    public function get($name)
    {
        if (!$this->has($name)) {
            return null;
        }

        return $this->collection[$name];
    }

    /**
     * (PHP 5 &gt;= 5.0.0)<br/>
     * Retrieve an external iterator
     * @link http://php.net/manual/en/iteratoraggregate.getiterator.php
     * @return Traversable An instance of an object implementing <b>Iterator</b> or
     * <b>Traversable</b>
     */
    public function getIterator()
    {
        return new \ArrayIterator($this->all());
    }
}
