<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author Daniele Termini
 * @package Application\Core
 */

namespace Application\Core\LinkType\Handler;

use Application\Core\Entity\LinkTypeDetails;
use Application\Core\Entity\LinkTypeInterface;
use Application\Core\LinkType\LinkHandlerInterface;

/**
 * Class LinkHandler
 *
 * @fixme: Rinominare in TextValueHandler
 */
class LinkHandler implements LinkHandlerInterface
{
    /**
     * @var string
     */
    protected $name;

    /**
     * @var string
     */
    protected $label;

    /**
     * @var string|null
     */
    protected $group;

    /**
     * @param string $name
     * @param string $label
     * @param string $group
     */
    public function __construct($name, $label, $group = null)
    {
        $this->name = $name;
        $this->label = $label;
        $this->group = $group;
    }

    /**
     * {@inheritdoc}
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * {@inheritdoc}
     */
    public function getLabel()
    {
        return $this->label;
    }

    /**
     * {@inheritdoc}
     */
    public function render($name, $value = null)
    {
        return '<input class="input_text" name="' . $name . '"' . ($value !== null ? ' value="' . $value . '"' : '') . '>';
    }

    /**
     * {@inheritdoc}
     */
    public function getUrl(array $request)
    {
        if (!array_key_exists($this->getName(), $request)) {
            throw new \InvalidArgumentException('The LinkType value for ' .  $this->getName(). ' is not set in the request');
        }

        return $request[$this->getName()];
    }

    /**
     * {@inheritdoc}
     */
    public function getDetails(array $request)
    {
        return new LinkTypeDetails(null, null);
    }

    /**
     * {@inheritdoc}
     */
    public function getValue(LinkTypeInterface $link_type)
    {
        return $link_type->getUrl();
    }

    /**
     * {@inheritdoc}
     */
    public function getGroup()
    {
        return $this->group;
    }
}
