<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author Daniele Termini
 * @package Application\Core
 */

namespace Application\Core\LinkType;

use Application\Core\Entity\LinkTypeInterface;

/**
 * Class Binder
 */
class Binder
{
    protected $resources = array();

    /**
     * @param string            $name
     * @param ResourceInterface $resource
     */
    public function register($name, ResourceInterface $resource)
    {
        $this->resources[$name] = $resource;
    }

    /**
     * @param string $name
     * @return ResourceInterface
     */
    public function getBound($name)
    {
        if (isset($this->resources[$name])) {
            return $this->resources[$name];
        }

        throw new \LogicException(sprintf('The LinkType resource "%s" is not implemented', $name));
    }
}
