CREATE OR REPLACE FUNCTION fixDates() RETURNS text AS $$
DECLARE
	col RECORD;
	sql TEXT;
BEGIN
	FOR col IN
		SELECT 
		  columns.table_schema, 
		  columns.table_catalog, 
		  columns.table_name, 
		  columns.column_name, 
		  columns.column_default, 
		  columns.is_nullable, 
		  columns.data_type, 
		  columns.character_maximum_length
		FROM 
		  information_schema.columns, 
		  information_schema.tables
		WHERE 
		  columns.table_schema = tables.table_schema AND
		  columns.table_name = tables.table_name AND
		  tables.table_catalog = columns.table_catalog AND
		  tables.table_schema = 'public' AND
		  columns.data_type = 'timestamp without time zone'
	LOOP

		SELECT 'UPDATE ' || col.table_name || ' SET ' || col.column_name || ' = NULL WHERE date_part(''year'', ' || col.column_name || ') < 1900' INTO sql;
		EXECUTE sql;
		RAISE NOTICE '%', sql;

	END LOOP;

	RETURN 'OK';
END;

$$ LANGUAGE plpgsql;

SELECT fixDates();