<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\I18n\Translation\Loader;

use Application\Core\Localization;
use Symfony\Component\Translation\Loader\LoaderInterface;
use Symfony\Component\Translation\MessageCatalogue;

/**
 * LocalizationLoader
 */
class LocalizationLoader implements LoaderInterface
{
    /**
     * @var Localization
     */
    protected $lang;

    /**
     * @param Localization $lang
     */
    public function __construct(Localization $lang)
    {
        $this->lang = $lang;
    }

    /**
     * {@inheritdoc}
     */
    public function load($resource, $locale, $domain = 'messages')
    {
        $catalogue = new MessageCatalogue($locale);
        $catalogue->add($this->lang->all(), $domain);

        return $catalogue;
    }
}
