<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\I18n;

/**
 * LocaleInterface
 */
interface LocaleInterface
{
    /**
     * @param float $price
     * @param bool  $showCurrency
     * @param bool  $showDecimal
     * @return string
     */
    public function formatPrice($price, $showCurrency = true, $showDecimal = true);

    /**
     * @param string $price
     * @return float
     */
    public function parsePrice($price);
}
