<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\I18n\Country\US;

use Application\Core\I18n\Address\AddressInterface;
use Application\Core\I18n\Address\AddressRendererInterface;
use Application\Core\Model\Province;

/**
 * AddressRenderer.
 */
class AddressRenderer implements AddressRendererInterface
{
    /**
     * {@inheritdoc}
     */
    public function render(AddressInterface $address)
    {
        $rows = array();
        $rows[] = $this->renderName($address);
        $rows[] = $address->getStreet();

        if ($address->getAdditionalInfo()) {
            $rows[] = $address->getAdditionalInfo();
        }

        $rows[] = $this->renderCityAndPostCodeAndProvince($address);

        if ($address->getCountry()) {
            $rows[] = $address->getCountry();
        }

        if ($address->getTelephone()) {
            $rows[] = 'T. ' . $address->getTelephone();
        }

        return implode('<br>', $rows);
    }

    /**
     * @param AddressInterface $address
     * @return string
     */
    protected function renderName(AddressInterface $address)
    {
        return trim($address->getFirstName() . ' ' . $address->getLastName());
    }

    /**
     * @param AddressInterface $address
     * @return string
     */
    protected function renderCityAndPostCodeAndProvince(AddressInterface $address)
    {
        $province = $address->getProvince();
        if ($province instanceof Province) {
            $province = $province->plate;
        }

        return implode(' ', [$address->getCity(), $province, $address->getPostCode()]);
    }
}
