<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\I18n\Country\IT;

use Application\Core\I18n\Address\AddressInterface;
use Application\Core\I18n\Address\AddressValidatorInterface;

/**
 * AddressValidator.
 */
class AddressValidator implements AddressValidatorInterface
{
    /**
     * {@inheritdoc}
     */
    public function validate(AddressInterface $address, array &$errors = array())
    {
        foreach ($this->required() as $name => $options) {
            list($method, $error_message) = $options;

            $value = $address->$method();

            if (empty($value)) {
                $errors[$name] = $error_message;
            }
        }

        if (!isset($errors['postcode']) && !preg_match('#^[0-9]{5}$#', $address->getPostCode())) {
            $errors['postcode'] = 'invalid_postcode_format';
        }

        return empty($errors);
    }

    /**
     * @return array
     */
    protected function required()
    {
        return array(
            'name'      => array('getFirstName', 'required_name'),
            'surname'   => array('getLastName', 'required_surname'),
            'address'   => array('getStreet', 'required_address'),
            'city'      => array('getCity', 'required_city'),
            'postcode'  => array('getPostCode', 'required_postcode'),
            'province'  => array('getProvince', 'required_province'),
            'country'   => array('getCountry', 'required_country'),
            'telephone' => array('getTelephone', 'required_telephone'),
        );
    }
}
