<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\I18n\Address;

/**
 * AddressValidatorFactory
 */
class AddressValidatorFactory
{
    /**
     * @param string $countryCode
     * @return AddressValidatorInterface
     */
    public function create($countryCode)
    {
        $class = "Application\\Core\\I18n\\Country\\{$countryCode}\\AddressValidator";

        if (!class_exists($class)) {
            $class = 'Application\\Core\\I18n\\Country\\IT\\AddressValidator';
        }

        return new $class();
    }
}
