<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\I18n\Address;

/**
 * AddressRendererFactory
 */
class AddressRendererFactory
{
    /**
     * @param string $countryCode
     * @return AddressRendererInterface
     */
    public function create($countryCode)
    {
        $class = "Application\\Core\\I18n\\Country\\{$countryCode}\\AddressRenderer";

        if (!class_exists($class)) {
            $class = 'Application\\Core\\I18n\\Country\\IT\\AddressRenderer';
        }

        return new $class();
    }
}