<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\I18n\Address;

/**
 * AddressInterface.
 */
interface AddressInterface
{
    /**
     * getFirstName
     *
     * @return string
     */
    public function getFirstName();

    /**
     * getLastName
     *
     * @return string
     */
    public function getLastName();

    /**
     * getCompany
     *
     * @return string
     */
    public function getCompany();

    /**
     * getStreet
     *
     * @return string
     */
    public function getStreet();

    /**
     * getAdditionalInfo
     *
     * @return string
     */
    public function getAdditionalInfo();

    /**
     * getCity
     *
     * @return string
     */
    public function getCity();

    /**
     * getPostCode
     *
     * @return string
     */
    public function getPostCode();

    /**
     * getProvince
     *
     * @return \Application\Core\Model\Province
     */
    public function getProvince();

    /**
     * getCountry
     *
     * @return \Application\Core\Model\Country
     */
    public function getCountry();

    /**
     * getTelephone
     *
     * @return string
     */
    public function getTelephone();
}
