<?php

namespace Application\Core\Form;

use Application\Admin\Form\PasswordField;

class UserPasswordField extends PasswordField
{
	/**
	 * @implements
	 */
	public function setAttributeModel()
	{
		if ( isset($_POST[$this->post_name]) && !empty($_POST[$this->post_name]) )
		{
			$this->model->{$this->attribute_name} = clean_password($_POST[$this->post_name]);
		}
	}

	/**
	 * @inherits
	 */
	protected function getFieldType()
	{
		return 'password';
	}

	/**
	 * @inherits
	 */
	protected function getFieldValue()
	{
		return '';
	}

	/**
	 * @inherits
	 */
	protected function generateCode(array $attributes)
	{
		$attributes['autocomplete'] = 'off';

		return parent::generateCode($attributes);
	}
}